package com.agilex.healthcare.directscheduling.mdws.connection;


import java.util.HashMap;

import com.agilex.healthcare.directscheduling.validator.MdwsResponseException;

public class MdwsConfiguration {

	private String endPointUrl;
	private String endPointBaseUrl;

	private int wsConnectTimeout;
	private int wsRequestTimeout;

	private HashMap<String, VistaSite> vistaSites;

    private boolean pingWsdlBeforeConnect = false;

	public MdwsConfiguration() {

	}

	public MdwsConfiguration(String endPointUrl, int wsRequestTimeout, int wsConnectTimeout) {
		this.endPointUrl = endPointUrl;
		this.wsConnectTimeout = wsConnectTimeout;
		this.wsRequestTimeout = wsRequestTimeout;
	}
	public MdwsConfiguration(String endPointBaseUrl, String endPointUrl, int wsRequestTimeout, int wsConnectTimeout, HashMap<String, VistaSite> vistaSites) {
		this(endPointUrl, wsRequestTimeout, wsConnectTimeout);
		this.endPointBaseUrl = endPointBaseUrl;
		this.vistaSites = vistaSites;
	}
	public MdwsConfiguration(String endPointBaseUrl, String endPointUrl, int wsRequestTimeout, int wsConnectTimeout) {
		this(endPointUrl, wsRequestTimeout, wsConnectTimeout);
		this.endPointBaseUrl = endPointBaseUrl;
	}

	public String getEndPointUrl() {
		return endPointUrl;
	}

	public void setEndPointUrl(String endPointUrl) {
		this.endPointUrl = endPointUrl;
	}

	public String getEndPointBaseUrl() {
		return endPointBaseUrl;
	}

	public void setEndPointBaseUrl(String endPointBaseUrl) {
		this.endPointBaseUrl = endPointBaseUrl;
	}

	public int getWsConnectTimeout() {
		return wsConnectTimeout;
	}

	public void setWsConnectTimeout(int wsConnectTimeout) {
		this.wsConnectTimeout = wsConnectTimeout;
	}

	public int getWsRequestTimeout() {
		return wsRequestTimeout;
	}

	public void setWsRequestTimeout(int wsRequestTimeout) {
		this.wsRequestTimeout = wsRequestTimeout;
	}

    public boolean isPingWsdlBeforeConnect() {
        return pingWsdlBeforeConnect;
    }

	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();

		builder.append("baseUrl: ");
		builder.append(getEndPointBaseUrl());
		builder.append(" - EndpointUrl: ");
		builder.append(getEndPointUrl());

		return builder.toString();

	}

	public HashMap<String, VistaSite> getVistaSites() {
		return vistaSites;
	}

	public VistaSite getVistaSite(String siteCode) {
		VistaSite vistaSite = null;
		if (vistaSites != null)
			vistaSite = vistaSites.get(siteCode);
		else {
			throw new MdwsResponseException(MdwsResponseException.UserMessages.CONNECTION_ERROR, "Cannot find vista sites configuration for siteCode: " + siteCode);
		}
		return vistaSite;
	}
}